var APIurl = 'http://127.0.0.1:8087';
var $TWSP = (function () {
    var bootstrapTable_common = {
        method: 'get',
        striped: true,
        cache: false,
        pagination: true,
        sortable: false,
        sidePagination: "server",
        pageNumber: 1,
        pageSize: 10,
        pageList: [5, 10, 25, 50, 100],
        strictSearch: true,
        showColumns: false,
        minimumCountColumns: 2,
        clickToSelect: true,
        cardView: false,
        detailView: false,
        smartDisplay: false,
        queryParams: function (params) {
            return {
                pageSize: params.limit,
                pageNum: params.offset / params.limit + 1
            };
        }
    };
    function _initTable(id, settings) {
        var params = $.extend({}, bootstrapTable_common, settings);
        if (typeof params.url === 'undefined') {
            throw '请配置url参数！';
        }
        if (typeof params.columns === 'undefined') {
            throw '请配置columns参数！';
        }
        $('#' + id).bootstrapTable(params);
    }
    function conver(gp){
        var lng = parseFloat(gp[1]);
        var lat = parseFloat(gp[0]);
        var point = new BMap.Point(gcj02tobd09(wgs84togcj02(lng,lat)[0],
            wgs84togcj02(lng,lat)[1])[0],
            gcj02tobd09(wgs84togcj02(lng,lat)[0],wgs84togcj02(lng,lat)[1])[1]);
        return point;
    }
    return {
        initTable: function (id, setting) {
            _initTable(id, setting);
        },
        refreshTable: function (id) {
            $('#' + id).bootstrapTable('refresh');
        },
        importData: function (form_id,post_url){
            var formData = new FormData($("#"+form_id)[0]);
            $.ajax({
                url: post_url,
                type: 'POST',
                data: formData,
                async: false,
                cache: false,
                contentType: false,
                processData: false,
                success: function (r) {
                    if(r.code === 0){alert(r.msg); $TWSP.refreshTable("table"); $('#closeWin').click(); }else{alert(r.msg); $('#closeWin').click(); }
                },
                error: function (returndata) {alert("未知错误");}
            });
        },
        exportExcel: function(post_url){
            $.post(post_url, function (r) {
                if (r.code === 0) {
                    window.location.href = "common/download?fileName=" + r.msg + "&delete=" + true + "&dowmType=0";
                } else {
                    alert(r.msg);
                }
            });
        },
        exportExcelParam: function(post_url,param){
            $.ajax({
                url: post_url,
                type: "POST",
                data: param,
                success: function(res) {
                    if (res.code === 0) {
                        window.location.href = "/common/download?fileName=" + res.msg + "&delete=" + true + "&dowmType=0";
                    } else {
                        alert(res.msg);
                    }
                }
            });
        },
        onkeyDown : function(id){
            document.onkeydown = function(event){
                if(!event){
                    event = window.event;// 火狐浏览器
                }
                if((event.keyCode || event.which) == 13){
                    $("#"+id).click();
                }
            }
        },
        clearVehicleId : function(){
            var valu = $('#combox-queryIdnos').val();
            if( valu == undefined || valu == ""){
                $('#hidden-queryIdnos').val('');
            }
        },
        clearTableData : function(id){
            $("#"+id).bootstrapTable('removeAll');
        },
        converAddress : function(arrPoint,ind,custom){
            var aTEXT = $('a['+custom+'="test'+ind+'"]').text();
            if(String(arrPoint).indexOf("&") != -1 ){ //parseFloat
                var gp = arrPoint.split("&"); //字符分割
                var pt = conver(gp);
                var gc = new BMap.Geocoder();
                gc.getLocation(pt, function (rs) {
                    var addComp = rs.addressComponents;
                    var result_addr;
                    result_addr = `${addComp.province}${addComp.city}${addComp.district}${addComp.street}${addComp.streetNumber}`;
                    $('a['+custom+'="test'+ind+'"]').text(result_addr);
                })
            }else{
                $('a['+custom+'="test'+ind+'"]').text('获取地址失败');
            }
        }
    }
})($)

